"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentileAnnotations = PercentileAnnotations;
var React = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function generateAnnotationData(values) {
  return Object.entries(values !== null && values !== void 0 ? values : {}).map(value => ({
    dataValue: value[1],
    details: `${(+value[0]).toFixed(0)}`
  }));
}
function PercentileAnnotations({
  percentiles
}) {
  var _generateAnnotationDa;
  const dataValues = (_generateAnnotationDa = generateAnnotationData(percentiles)) !== null && _generateAnnotationDa !== void 0 ? _generateAnnotationDa : [];
  const style = {
    line: {
      strokeWidth: 1,
      stroke: _uiTheme.euiLightVars.euiColorSuccess,
      opacity: 1
    }
  };
  function PercentileTooltip({
    annotation
  }) {
    return /*#__PURE__*/React.createElement("span", {
      "data-cy": "percentileTooltipTitle"
    }, annotation.details, "th Percentile");
  }
  return /*#__PURE__*/React.createElement(React.Fragment, null, dataValues.map((annotation, index) => /*#__PURE__*/React.createElement(_charts.LineAnnotation, {
    id: index + 'annotation_' + annotation.dataValue,
    key: index + 'percentile_' + annotation.dataValue,
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: [annotation],
    style: style,
    hideTooltips: true,
    markerPosition: _charts.Position.Top,
    marker: /*#__PURE__*/React.createElement("span", {
      "data-cy": "percentile-markers"
    }, /*#__PURE__*/React.createElement(_eui.EuiToolTip, {
      title: /*#__PURE__*/React.createElement(PercentileTooltip, {
        annotation: annotation
      }),
      content: /*#__PURE__*/React.createElement("span", null, "Pages loaded: ", Math.round(annotation.dataValue))
    }, /*#__PURE__*/React.createElement(React.Fragment, null, annotation.details, "th")))
  })));
}