"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClientMetrics = ClientMetrics;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../translations");
var _translations2 = require("../ux_metrics/translations");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _metrics = require("./metrics");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ClientMetrics() {
  const {
    urlParams: {
      percentile
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  return /*#__PURE__*/React.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-cy": `client-metrics`
  }, /*#__PURE__*/React.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, _translations.I18LABELS.pageLoad, " (", (0, _translations2.getPercentileLabel)(percentile), ")")), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(_metrics.Metrics, null))));
}