"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageLoadDistChart = PageLoadDistChart;
var _react = _interopRequireWildcard(require("react"));
var _get_exp_view_filter = require("../../../../services/data/get_exp_view_filter");
var _use_exp_view_attrs = require("./use_exp_view_attrs");
var _use_data_view = require("../local_uifilters/use_data_view");
var _use_kibana_services = require("../../../../hooks/use_kibana_services");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PageLoadDistChart({
  onPercentileChange,
  breakdown
}) {
  const {
    dataViewTitle
  } = (0, _use_data_view.useDataView)();
  const {
    uxUiFilters,
    urlParams
  } = (0, _use_url_params.useLegacyUrlParams)();
  const kibana = (0, _use_kibana_services.useKibanaServices)();
  const {
    ExploratoryViewEmbeddable
  } = kibana.exploratoryView;
  const onBrushEnd = (0, _react.useCallback)(({
    range
  }) => {
    if (!range) {
      return;
    }
    const [minX, maxX] = range;
    onPercentileChange(minX, maxX);
  }, [onPercentileChange]);
  const {
    reportDefinitions,
    time
  } = (0, _use_exp_view_attrs.useExpViewAttributes)();
  const allSeries = [{
    time,
    reportDefinitions,
    dataType: 'ux',
    name: 'page-load-distribution',
    selectedMetricField: _elasticsearch_fieldnames.TRANSACTION_DURATION,
    breakdown: breakdown === null || breakdown === void 0 ? void 0 : breakdown.fieldName,
    filters: (0, _get_exp_view_filter.getExploratoryViewFilter)(uxUiFilters, urlParams)
  }];
  if (!dataViewTitle) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    customHeight: '300px',
    attributes: allSeries,
    onBrushEnd: onBrushEnd,
    reportType: "data-distribution",
    dataTypesIndexPatterns: {
      ux: dataViewTitle
    },
    legendIsVisible: Boolean(breakdown),
    axisTitlesVisibility: {
      x: true,
      yLeft: true,
      yRight: false
    }
  });
}