"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGlobalVariableList = void 0;
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _i18n2 = require("./i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const kind = _monaco.monaco.languages.CompletionItemKind.Constant;
const sortPrefix = '3.';
const getGlobalVariableList = values => {
  const globalVariables = [{
    label: 'kibanaUrl',
    sortText: sortPrefix + 'kibanaUrl',
    title: _i18n.i18n.translate('xpack.urlDrilldown.global.kibanaUrl.documentation.title', {
      defaultMessage: 'Link to Kibana homepage.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.global.kibanaUrl.documentation', {
      defaultMessage: 'Kibana base URL. Useful for creating URL drilldowns that navigate within Kibana.'
    }) + '\n\n' + (0, _i18n2.txtValue)(values.kibanaUrl),
    kind
  }];
  return globalVariables;
};
exports.getGlobalVariableList = getGlobalVariableList;