"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.monitorListReducer = exports.initialState = void 0;
var _reduxActions = require("redux-actions");
var _actions = require("../actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  list: {
    nextPagePagination: null,
    prevPagePagination: null,
    summaries: []
  },
  loading: false,
  isLoaded: false
};
exports.initialState = initialState;
const monitorListReducer = (0, _reduxActions.handleActions)({
  [String(_actions.getMonitorList)]: state => ({
    ...state,
    loading: true
  }),
  [String(_actions.getMonitorListSuccess)]: (state, action) => ({
    ...state,
    loading: false,
    isLoaded: true,
    error: undefined,
    list: {
      ...action.payload
    }
  }),
  [String(_actions.getMonitorListFailure)]: (state, action) => ({
    ...state,
    error: action.payload,
    loading: false,
    isLoaded: true
  })
}, initialState);
exports.monitorListReducer = monitorListReducer;