"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rootReducer = void 0;
var _redux = require("redux");
var _monitor = require("./monitor");
var _ui = require("./ui");
var _monitor_status = require("./monitor_status");
var _monitor_list = require("./monitor_list");
var _dynamic_settings = require("./dynamic_settings");
var _ping = require("./ping");
var _ping_list = require("./ping_list");
var _monitor_duration = require("./monitor_duration");
var _index_status = require("./index_status");
var _ml_anomaly = require("./ml_anomaly");
var _certificates = require("../certificates/certificates");
var _selected_filters = require("./selected_filters");
var _alerts = require("../alerts/alerts");
var _journey = require("./journey");
var _network_events = require("./network_events");
var _synthetics = require("./synthetics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rootReducer = (0, _redux.combineReducers)({
  monitor: _monitor.monitorReducer,
  ui: _ui.uiReducer,
  monitorList: _monitor_list.monitorListReducer,
  monitorStatus: _monitor_status.monitorStatusReducer,
  dynamicSettings: _dynamic_settings.dynamicSettingsReducer,
  ping: _ping.pingReducer,
  pingList: _ping_list.pingListReducer,
  ml: _ml_anomaly.mlJobsReducer,
  monitorDuration: _monitor_duration.monitorDurationReducer,
  indexStatus: _index_status.indexStatusReducer,
  certificates: _certificates.certificatesReducer,
  selectedFilters: _selected_filters.selectedFiltersReducer,
  alerts: _alerts.alertsReducer,
  journeys: _journey.journeyReducer,
  networkEvents: _network_events.networkEventsReducer,
  synthetics: _synthetics.syntheticsReducer
});
exports.rootReducer = rootReducer;