"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchMonitorLocations = exports.fetchMonitorDetails = void 0;
var _runtime_types = require("../../../../common/runtime_types");
var _utils = require("./utils");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchMonitorDetails = async ({
  monitorId,
  dateStart,
  dateEnd
}) => {
  const params = {
    monitorId,
    dateStart,
    dateEnd
  };
  return await _utils.apiService.get(_constants.API_URLS.MONITOR_DETAILS, params, _runtime_types.MonitorDetailsType);
};
exports.fetchMonitorDetails = fetchMonitorDetails;
const fetchMonitorLocations = async ({
  monitorId,
  dateStart,
  dateEnd
}) => {
  const params = {
    dateStart,
    dateEnd,
    monitorId
  };
  return await _utils.apiService.get(_constants.API_URLS.MONITOR_LOCATIONS, params, _runtime_types.MonitorLocationsType);
};
exports.fetchMonitorLocations = fetchMonitorLocations;