"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegacyApmHref = void 0;
var _add_base_path = require("./add_base_path");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLegacyApmHref = (summary, basePath, dateRangeStart, dateRangeEnd) => {
  var _summary$state, _summary$state$servic, _summary$state$url;
  const serviceName = summary === null || summary === void 0 ? void 0 : (_summary$state = summary.state) === null || _summary$state === void 0 ? void 0 : (_summary$state$servic = _summary$state.service) === null || _summary$state$servic === void 0 ? void 0 : _summary$state$servic.name;
  if (serviceName) {
    return (0, _add_base_path.addBasePath)(basePath, `/app/apm/services/${serviceName}/overview/?rangeFrom=${dateRangeStart}&rangeTo=${dateRangeEnd}`);
  }
  const clause = `url.domain: "${(_summary$state$url = summary.state.url) === null || _summary$state$url === void 0 ? void 0 : _summary$state$url.domain}"`;
  return (0, _add_base_path.addBasePath)(basePath, `/app/apm/services?kuery=${encodeURI(clause)}&rangeFrom=${dateRangeStart}&rangeTo=${dateRangeEnd}`);
};
exports.getLegacyApmHref = getLegacyApmHref;