"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCertStatus = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _reactRedux = require("react-redux");
var _selectors = require("../state/selectors");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCertStatus = (expiryDate, issueDate) => {
  var _dss$settings, _dss$settings2;
  const dss = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const expiryThreshold = (_dss$settings = dss.settings) === null || _dss$settings === void 0 ? void 0 : _dss$settings.certExpirationThreshold;
  const ageThreshold = (_dss$settings2 = dss.settings) === null || _dss$settings2 === void 0 ? void 0 : _dss$settings2.certAgeThreshold;
  const certValidityDate = new Date(expiryDate !== null && expiryDate !== void 0 ? expiryDate : '');
  const isValidDate = !isNaN(certValidityDate.valueOf());
  if (!isValidDate) {
    return false;
  }
  const isExpiringSoon = (0, _moment.default)(certValidityDate).diff((0, _moment.default)(), 'days') < expiryThreshold;
  const isTooOld = (0, _moment.default)().diff((0, _moment.default)(issueDate), 'days') > ageThreshold;
  const isExpired = (0, _moment.default)(certValidityDate) < (0, _moment.default)();
  if (isExpired) {
    return _constants.CERT_STATUS.EXPIRED;
  }
  return isExpiringSoon ? _constants.CERT_STATUS.EXPIRING_SOON : isTooOld ? _constants.CERT_STATUS.TOO_OLD : _constants.CERT_STATUS.OK;
};
exports.useCertStatus = useCertStatus;