"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUptimeDataView = exports.UptimeDataViewContextProvider = exports.UptimeDataViewContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_has_data = require("../components/overview/empty_state/use_has_data");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UptimeDataViewContext = /*#__PURE__*/(0, _react.createContext)({});
exports.UptimeDataViewContext = UptimeDataViewContext;
const UptimeDataViewContextProvider = ({
  children,
  dataViews
}) => {
  const {
    settings,
    data: indexStatus
  } = (0, _use_has_data.useHasData)();
  const heartbeatIndices = (settings === null || settings === void 0 ? void 0 : settings.heartbeatIndices) || '';
  const {
    data
  } = (0, _public.useFetcher)(async () => {
    if (heartbeatIndices && indexStatus !== null && indexStatus !== void 0 && indexStatus.indexExists) {
      // this only creates an dateView in memory, not as saved object
      return dataViews.create({
        title: heartbeatIndices
      });
    }
  }, [heartbeatIndices, indexStatus === null || indexStatus === void 0 ? void 0 : indexStatus.indexExists]);
  return /*#__PURE__*/_react.default.createElement(UptimeDataViewContext.Provider, {
    value: data,
    children: children
  });
};
exports.UptimeDataViewContextProvider = UptimeDataViewContextProvider;
const useUptimeDataView = () => (0, _react.useContext)(UptimeDataViewContext);
exports.useUptimeDataView = useUptimeDataView;