"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SettingsActions = ({
  isFormDisabled,
  isFormDirty,
  isFormValid,
  onApply,
  onCancel,
  errors
}) => {
  const {
    heartbeatIndices,
    invalidEmail,
    expirationThresholdError,
    ageThresholdError
  } = errors !== null && errors !== void 0 ? errors : {};
  const {
    to,
    cc,
    bcc
  } = invalidEmail !== null && invalidEmail !== void 0 ? invalidEmail : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(WarningText, null, heartbeatIndices || to || cc || bcc || expirationThresholdError || ageThresholdError)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "text",
    size: "s",
    iconType: "cross",
    "data-test-subj": "discardSettingsButton",
    isDisabled: !isFormDirty || isFormDisabled,
    onClick: () => {
      onCancel();
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.discardSettingsButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    "data-test-subj": "apply-settings-button",
    onClick: onApply,
    color: "primary",
    isDisabled: !isFormDirty || !isFormValid || isFormDisabled,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.applySettingsButtonLabel",
    defaultMessage: "Apply changes"
  }))));
};
exports.SettingsActions = SettingsActions;
const WarningText = (0, _common.euiStyled)(_eui.EuiText)`
    box-shadow: -4px 0 ${props => props.theme.eui.euiColorWarning};
    padding-left: 8px;
`;