"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExpandDrawerLabel = exports.getDescriptionLabel = exports.TLS_COLUMN_LABEL = exports.STATUS_COLUMN_LABEL = exports.STATUS_ALERT_COLUMN = exports.NO_MONITOR_ITEM_SELECTED = exports.NO_DATA_MESSAGE = exports.NAME_COLUMN_LABEL = exports.LOADING = exports.HISTORY_COLUMN_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATUS_COLUMN_LABEL = _i18n.i18n.translate('xpack.uptime.monitorList.statusColumnLabel', {
  defaultMessage: 'Status'
});
exports.STATUS_COLUMN_LABEL = STATUS_COLUMN_LABEL;
const NAME_COLUMN_LABEL = _i18n.i18n.translate('xpack.uptime.monitorList.nameColumnLabel', {
  defaultMessage: 'Name'
});
exports.NAME_COLUMN_LABEL = NAME_COLUMN_LABEL;
const HISTORY_COLUMN_LABEL = _i18n.i18n.translate('xpack.uptime.monitorList.monitorHistoryColumnLabel', {
  defaultMessage: 'Downtime history'
});
exports.HISTORY_COLUMN_LABEL = HISTORY_COLUMN_LABEL;
const TLS_COLUMN_LABEL = _i18n.i18n.translate('xpack.uptime.monitorList.tlsColumnLabel', {
  defaultMessage: 'TLS Certificate'
});
exports.TLS_COLUMN_LABEL = TLS_COLUMN_LABEL;
const getExpandDrawerLabel = id => {
  return _i18n.i18n.translate('xpack.uptime.monitorList.expandDrawerButton.ariaLabel', {
    defaultMessage: 'Expand row for monitor with ID {id}',
    description: 'The user can click a button on this table and expand further details.',
    values: {
      id
    }
  });
};
exports.getExpandDrawerLabel = getExpandDrawerLabel;
const getDescriptionLabel = itemsLength => {
  return _i18n.i18n.translate('xpack.uptime.monitorList.table.description', {
    defaultMessage: 'Monitor Status table with columns for Status, Name, URL, IP, Downtime History and Integrations. The table is currently displaying {length} items.',
    values: {
      length: itemsLength
    }
  });
};
exports.getDescriptionLabel = getDescriptionLabel;
const NO_MONITOR_ITEM_SELECTED = _i18n.i18n.translate('xpack.uptime.monitorList.noItemForSelectedFiltersMessage', {
  defaultMessage: 'No monitors found for selected filter criteria',
  description: 'This message is show if there are no monitors in the table and some filter or search criteria exists'
});
exports.NO_MONITOR_ITEM_SELECTED = NO_MONITOR_ITEM_SELECTED;
const LOADING = _i18n.i18n.translate('xpack.uptime.monitorList.loading', {
  defaultMessage: 'Loading...',
  description: 'Shown when the monitor list is waiting for a server response'
});
exports.LOADING = LOADING;
const NO_DATA_MESSAGE = _i18n.i18n.translate('xpack.uptime.monitorList.noItemMessage', {
  defaultMessage: 'No uptime monitors found',
  description: 'This message is shown if the monitors table is rendered but has no items.'
});
exports.NO_DATA_MESSAGE = NO_DATA_MESSAGE;
const STATUS_ALERT_COLUMN = _i18n.i18n.translate('xpack.uptime.monitorList.statusAlert.label', {
  defaultMessage: 'Status alert'
});
exports.STATUS_ALERT_COLUMN = STATUS_ALERT_COLUMN;