"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoItemsMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var labels = _interopRequireWildcard(require("./translations"));
var _hooks = require("../../../hooks");
var _selectors = require("../../../state/selectors");
var _troubleshoot_popover = require("./troubleshoot_popover");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoItemsMessage = ({
  loading,
  filters
}) => {
  const {
    statusFilter
  } = (0, _hooks.useGetUrlParams)();
  const {
    pingHistogram
  } = (0, _reactRedux.useSelector)(_selectors.selectPingHistogram);
  const hasPingsData = (pingHistogram === null || pingHistogram === void 0 ? void 0 : pingHistogram.histogram) && pingHistogram.histogram.length > 0;
  const clockSyncError = hasPingsData && !statusFilter ? /*#__PURE__*/_react.default.createElement(_troubleshoot_popover.TroubleshootPopover, null) : null;
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, " ", labels.LOADING);
  }
  if (filters) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, labels.NO_MONITOR_ITEM_SELECTED), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, clockSyncError)));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, labels.NO_DATA_MESSAGE, clockSyncError);
};
exports.NoItemsMessage = NoItemsMessage;