"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _location_link = require("../../../common/location_link");
var _monitor_status_row = require("./monitor_status_row");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorStatusList = ({
  summaryPings
}) => {
  const upChecks = new Set();
  const downChecks = new Set();
  summaryPings.forEach(ping => {
    var _ping$observer$geo$na, _ping$observer, _ping$observer$geo;
    // Doing this way because name is either string or null, get() default value only works on undefined value
    const location = (_ping$observer$geo$na = (_ping$observer = ping.observer) === null || _ping$observer === void 0 ? void 0 : (_ping$observer$geo = _ping$observer.geo) === null || _ping$observer$geo === void 0 ? void 0 : _ping$observer$geo.name) !== null && _ping$observer$geo$na !== void 0 ? _ping$observer$geo$na : _constants.UNNAMED_LOCATION;
    if (ping.monitor.status === _constants.STATUS.UP) {
      upChecks.add(location);
    } else if (ping.monitor.status === _constants.STATUS.DOWN) {
      downChecks.add(location);
    }
  });

  // if monitor is down in one dns, it will be considered down so removing it from up list
  const absUpChecks = new Set([...upChecks].filter(item => !downChecks.has(item)));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      maxWidth: 1000
    }
  }, downChecks.size > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_monitor_status_row.MonitorStatusRow, {
    locationNames: downChecks,
    status: _constants.STATUS.DOWN
  })), absUpChecks.size > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_monitor_status_row.MonitorStatusRow, {
    locationNames: absUpChecks,
    status: _constants.STATUS.UP
  }))), (downChecks.has(_constants.UNNAMED_LOCATION) || upChecks.has(_constants.UNNAMED_LOCATION)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.monitorList.drawer.missingLocation",
    defaultMessage: "Some heartbeat instances do not have a location defined. {link} to your heartbeat configuration.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_location_link.LocationLink, null)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })));
};
exports.MonitorStatusList = MonitorStatusList;