"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnabledAlerts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _contexts = require("../../../../contexts");
var _common = require("../../../../lib/alert_types/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LinkGroupList = (0, _styledComponents.default)(_eui.EuiListGroup)`
  &&& {
    a {
      padding-left: 0;
      padding-top: 0;
    }
  }
`;
const EnabledAlerts = ({
  monitorAlerts,
  loading
}) => {
  const {
    basePath
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const listItems = [];
  (monitorAlerts !== null && monitorAlerts !== void 0 ? monitorAlerts : []).forEach((alert, ind) => {
    listItems.push({
      size: 's',
      label: alert.name,
      href: (0, _common.getUrlForAlert)(alert.id, basePath),
      'data-test-subj': 'uptimeMonitorListDrawerAlert' + ind
    });
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _i18n.i18n.translate('xpack.uptime.monitorList.enabledAlerts.title', {
    defaultMessage: 'Enabled rules',
    description: 'Rules enabled for this monitor'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, listItems.length === 0 && !loading && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: _i18n.i18n.translate('xpack.uptime.monitorList.enabledAlerts.noAlert', {
      defaultMessage: 'No rules are enabled for this monitor.'
    })
  }), loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : /*#__PURE__*/_react.default.createElement(LinkGroupList, {
    listItems: listItems,
    flush: true
  })));
};
exports.EnabledAlerts = EnabledAlerts;