"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _monitor_status_column = require("./monitor_status_column");
var _contexts = require("../../../../contexts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusBadge = ({
  status,
  summaryError
}) => {
  const {
    colors: {
      dangerBehindText
    }
  } = (0, _react.useContext)(_contexts.UptimeThemeContext);
  if (status === _constants.STATUS.UP) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      className: "eui-textCenter",
      color: 'success'
    }, (0, _monitor_status_column.getHealthMessage)(status));
  }
  const errorMessage = summaryError === null || summaryError === void 0 ? void 0 : summaryError.message;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: errorMessage
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "eui-textCenter",
    color: dangerBehindText
  }, (0, _monitor_status_column.getHealthMessage)(status)));
};
exports.StatusBadge = StatusBadge;