"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedFilters = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/exploratory-view-plugin/public");
var _uptime_data_view_context = require("../../../contexts/uptime_data_view_context");
var _use_selected_filters = require("../../../hooks/use_selected_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SelectedFilters = ({
  onChange
}) => {
  const dataView = (0, _uptime_data_view_context.useUptimeDataView)();
  const {
    filtersList
  } = (0, _use_selected_filters.useSelectedFilters)();
  if (!dataView) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    wrap: true
  }, filtersList.map(({
    field,
    selectedItems,
    excludedItems,
    label
  }) => [...selectedItems.map(value => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: field + value,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_public.FilterValueLabel, {
    dataView: dataView,
    removeFilter: () => {
      onChange(field, selectedItems.filter(valT => valT !== value), excludedItems);
    },
    invertFilter: val => {
      onChange(field, selectedItems.filter(valT => valT !== value), [...excludedItems, value]);
    },
    field: field,
    value: value,
    negate: false,
    label: label
  }))), ...excludedItems.map(value => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: field + value,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_public.FilterValueLabel, {
    dataView: dataView,
    removeFilter: () => {
      onChange(field, selectedItems, excludedItems.filter(valT => valT !== value));
    },
    invertFilter: val => {
      onChange(field, [...selectedItems, value], excludedItems.filter(valT => valT !== value));
    },
    field: field,
    value: value,
    negate: true,
    label: label
  })))]));
};
exports.SelectedFilters = SelectedFilters;