"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHasData = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _actions = require("../../../state/actions");
var _selectors = require("../../../state/selectors");
var _contexts = require("../../../contexts");
var _dynamic_settings = require("../../../state/actions/dynamic_settings");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHasData = () => {
  const {
    loading,
    error,
    data
  } = (0, _reactRedux.useSelector)(_selectors.indexStatusSelector);
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const {
    settings
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const dispatch = (0, _reactRedux.useDispatch)();
  const isAddRoute = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ADD_ROUTE);
  const isEditRoute = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_EDIT_ROUTE);
  const isMonitorRoute = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ROUTE);
  const skippedRoute = (isAddRoute === null || isAddRoute === void 0 ? void 0 : isAddRoute.isExact) || (isEditRoute === null || isEditRoute === void 0 ? void 0 : isEditRoute.isExact) || (isMonitorRoute === null || isMonitorRoute === void 0 ? void 0 : isMonitorRoute.isExact);
  (0, _react.useEffect)(() => {
    if (!skippedRoute) {
      dispatch(_actions.indexStatusAction.get());
    }
  }, [dispatch, lastRefresh, skippedRoute]);
  (0, _react.useEffect)(() => {
    dispatch((0, _dynamic_settings.getDynamicSettings)());
  }, [dispatch]);
  return {
    data,
    error,
    loading,
    settings
  };
};
exports.useHasData = useHasData;