"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderMonitorType = exports.MonitorStatusBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _translations = require("../../../overview/monitor_list/columns/translations");
var _selectors = require("../../../../state/selectors");
var _enable_alert = require("../../../overview/monitor_list/columns/enable_alert");
var _ssl_certificate = require("./ssl_certificate");
var labels = _interopRequireWildcard(require("../translations"));
var _status_by_location = require("./status_by_location");
var _use_status_bar = require("./use_status_bar");
var _translations3 = require("../../../../../../common/translations/translations");
var _availability_reporting = require("../availability_reporting/availability_reporting");
var _monitor_redirects = require("./monitor_redirects");
var _monitor_tags = require("../../../common/monitor_tags");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderMonitorType = type => {
  switch (type) {
    case 'http':
      return _i18n.i18n.translate('xpack.uptime.monitorDetails.statusBar.pingType.http', {
        defaultMessage: 'HTTP'
      });
    case 'tcp':
      return _i18n.i18n.translate('xpack.uptime.monitorDetails.statusBar.pingType.tcp', {
        defaultMessage: 'TCP'
      });
    case 'icmp':
      return _i18n.i18n.translate('xpack.uptime.monitorDetails.statusBar.pingType.icmp', {
        defaultMessage: 'ICMP'
      });
    case 'browser':
      return _i18n.i18n.translate('xpack.uptime.monitorDetails.statusBar.pingType.browser', {
        defaultMessage: 'Browser'
      });
    default:
      return '';
  }
};
exports.renderMonitorType = renderMonitorType;
const MonitorStatusBar = () => {
  var _monitorStatus$url$fu, _monitorStatus$url, _monitorStatus$monito, _monitorStatus$monito2, _monitorStatus$monito3, _monitorStatus$monito4, _monitorStatus$monito5;
  const {
    monitorId,
    monitorStatus,
    monitorLocations = {}
  } = (0, _use_status_bar.useStatusBar)();
  const {
    locations,
    up_history: ups,
    down_history: downs
  } = monitorLocations;
  const full = (_monitorStatus$url$fu = monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$url = monitorStatus.url) === null || _monitorStatus$url === void 0 ? void 0 : _monitorStatus$url.full) !== null && _monitorStatus$url$fu !== void 0 ? _monitorStatus$url$fu : '';
  const availability = ups === 0 && downs === 0 || !ups ? 0 : ups / (ups + downs) * 100;
  const selectedMonitor = (0, _reactRedux.useSelector)(_selectors.monitorStatusSelector);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_status_by_location.StatusByLocations, {
    locations: locations !== null && locations !== void 0 ? locations : []
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    compressed: true,
    textStyle: "reverse",
    columnWidths: [1, 3]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, labels.OverallAvailability), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "uptimeOverallAvailability"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.availabilityLabelText",
    defaultMessage: "{value} %",
    values: {
      value: (0, _availability_reporting.formatAvailabilityValue)(availability)
    },
    description: "A percentage value, like 23.5 %"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _translations3.URL_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "monitor-page-url",
    className: "eui-textBreakAll"
  }, full ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMonitorStatusBarLink",
    "aria-label": labels.monitorUrlLinkAriaLabel,
    href: full,
    target: "_blank",
    external: true
  }, full) : '--'), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, labels.MonitorIDLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "monitor-page-title"
  }, monitorId), (monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$monito = monitorStatus.monitor) === null || _monitorStatus$monito === void 0 ? void 0 : _monitorStatus$monito.type) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "aria-label": labels.typeAriaLabel
  }, labels.typeLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "monitor-page-type"
  }, renderMonitorType(monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$monito2 = monitorStatus.monitor) === null || _monitorStatus$monito2 === void 0 ? void 0 : _monitorStatus$monito2.type))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _translations3.TAGS_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_monitor_tags.MonitorTags, {
    ping: monitorStatus
  })), (monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$monito3 = monitorStatus.monitor) === null || _monitorStatus$monito3 === void 0 ? void 0 : (_monitorStatus$monito4 = _monitorStatus$monito3.project) === null || _monitorStatus$monito4 === void 0 ? void 0 : _monitorStatus$monito4.id) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _translations3.PROJECT_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$monito5 = monitorStatus.monitor) === null || _monitorStatus$monito5 === void 0 ? void 0 : _monitorStatus$monito5.project.id)), /*#__PURE__*/_react.default.createElement(_ssl_certificate.MonitorSSLCertificate, {
    tls: monitorStatus === null || monitorStatus === void 0 ? void 0 : monitorStatus.tls
  }), /*#__PURE__*/_react.default.createElement(_monitor_redirects.MonitorRedirects, {
    monitorStatus: monitorStatus
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, _translations.ENABLE_STATUS_ALERT), selectedMonitor && /*#__PURE__*/_react.default.createElement(_enable_alert.EnableMonitorAlert, {
    monitorId: monitorId,
    selectedMonitor: selectedMonitor
  })));
};
exports.MonitorStatusBar = MonitorStatusBar;