"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowLicenseInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _contexts = require("../../../contexts");
var labels = _interopRequireWildcard(require("./translations"));
var _actions = require("../../../state/actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShowLicenseInfo = () => {
  const {
    basePath
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch(_actions.getMLCapabilitiesAction.get());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "uptimeMLLicenseInfo",
    className: "license-info-trial",
    title: labels.START_TRAIL,
    color: "primary",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, labels.START_TRAIL_DESC), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsShowLicenseInfoButton",
    color: "primary",
    href: basePath + `/app/management/stack/license_management/home`
  }, labels.START_TRAIL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.ShowLicenseInfo = ShowLicenseInfo;