"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionMenuContent = ActionMenuContent;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _public = require("@kbn/exploratory-view-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _stringify_url_params = require("../../../lib/helper/url_params/stringify_url_params");
var _uptime_settings_context = require("../../../contexts/uptime_settings_context");
var _hooks = require("../../../hooks");
var _alerts_containers = require("../../overview/alerts/alerts_containers");
var _constants = require("../../../../../common/constants");
var _inspector_header_link = require("./inspector_header_link");
var _selectors = require("../../../state/selectors");
var _manage_monitors_btn = require("./manage_monitors_btn");
var _uptime_startup_plugins_context = require("../../../contexts/uptime_startup_plugins_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_DATA_LABEL = _i18n.i18n.translate('xpack.uptime.addDataButtonLabel', {
  defaultMessage: 'Add data'
});
const ANALYZE_DATA = _i18n.i18n.translate('xpack.uptime.analyzeDataButtonLabel', {
  defaultMessage: 'Explore data'
});
const ANALYZE_MESSAGE = _i18n.i18n.translate('xpack.uptime.analyzeDataButtonLabel.message', {
  defaultMessage: 'Go to Explore Data, where you can select and filter result data in any dimension and look for the cause or impact of performance problems.'
});
function ActionMenuContent() {
  var _selectedMonitor$moni, _selectedMonitor$moni2, _selectedMonitor$moni3, _kibana$services, _kibana$services$appl;
  const kibana = (0, _public2.useKibana)();
  const {
    basePath
  } = (0, _uptime_settings_context.useUptimeSettingsContext)();
  const {
    observabilityAIAssistant: {
      ObservabilityAIAssistantActionMenuItem
    } = {}
  } = (0, _uptime_startup_plugins_context.useUptimeStartPlugins)();
  const params = (0, _hooks.useGetUrlParams)();
  const {
    dateRangeStart,
    dateRangeEnd
  } = params;
  const history = (0, _reactRouterDom.useHistory)();
  const selectedMonitor = (0, _reactRedux.useSelector)(_selectors.monitorStatusSelector);
  const detailRouteMatch = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ROUTE);
  const monitorId = selectedMonitor === null || selectedMonitor === void 0 ? void 0 : (_selectedMonitor$moni = selectedMonitor.monitor) === null || _selectedMonitor$moni === void 0 ? void 0 : _selectedMonitor$moni.id;
  const syntheticExploratoryViewLink = (0, _public.createExploratoryViewUrl)({
    reportType: 'kpi-over-time',
    allSeries: [{
      dataType: 'uptime',
      seriesType: 'area',
      selectedMetricField: 'monitor.duration.us',
      time: {
        from: dateRangeStart,
        to: dateRangeEnd
      },
      breakdown: monitorId ? 'observer.geo.name' : 'monitor.type',
      reportDefinitions: {
        'monitor.name': selectedMonitor !== null && selectedMonitor !== void 0 && (_selectedMonitor$moni2 = selectedMonitor.monitor) !== null && _selectedMonitor$moni2 !== void 0 && _selectedMonitor$moni2.name && (detailRouteMatch === null || detailRouteMatch === void 0 ? void 0 : detailRouteMatch.isExact) === true ? [selectedMonitor === null || selectedMonitor === void 0 ? void 0 : (_selectedMonitor$moni3 = selectedMonitor.monitor) === null || _selectedMonitor$moni3 === void 0 ? void 0 : _selectedMonitor$moni3.name] : [],
        'url.full': ['ALL_VALUES']
      },
      name: monitorId ? `${monitorId}-response-duration` : 'All monitors response duration'
    }]
  }, basePath);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLinks, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_manage_monitors_btn.ManageMonitorsBtn, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    "aria-label": _i18n.i18n.translate('xpack.uptime.page_header.settingsLink.label', {
      defaultMessage: 'Navigate to the Uptime settings page'
    }),
    color: "text",
    "data-test-subj": "settings-page-link",
    href: history.createHref({
      pathname: _constants.SETTINGS_ROUTE,
      search: (0, _stringify_url_params.stringifyUrlParams)(params, true)
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.page_header.settingsLink",
    defaultMessage: "Settings"
  })), /*#__PURE__*/_react.default.createElement(_alerts_containers.ToggleAlertFlyoutButton, null), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: /*#__PURE__*/_react.default.createElement("p", null, ANALYZE_MESSAGE)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    "aria-label": _i18n.i18n.translate('xpack.uptime.page_header.analyzeData.label', {
      defaultMessage: 'Navigate to the "Explore Data" view to visualize Synthetics/User data'
    }),
    href: syntheticExploratoryViewLink,
    color: "text",
    iconType: "visBarVerticalStacked",
    "data-test-subj": 'uptimeExploreDataButton'
  }, ANALYZE_DATA)), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    "aria-label": _i18n.i18n.translate('xpack.uptime.page_header.addDataLink.label', {
      defaultMessage: 'Navigate to a tutorial about adding Uptime data'
    }),
    href: (_kibana$services = kibana.services) === null || _kibana$services === void 0 ? void 0 : (_kibana$services$appl = _kibana$services.application) === null || _kibana$services$appl === void 0 ? void 0 : _kibana$services$appl.getUrlForApp('/home#/tutorial/uptimeMonitors'),
    color: "primary",
    iconType: "indexOpen"
  }, ADD_DATA_LABEL), /*#__PURE__*/_react.default.createElement(_inspector_header_link.InspectorHeaderLink, null), ObservabilityAIAssistantActionMenuItem ? /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantActionMenuItem, null) : null);
}