"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecationBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  criticalBadgeLabel: _i18n.i18n.translate('xpack.upgradeAssistant.deprecationBadge.criticalBadgeLabel', {
    defaultMessage: 'Critical'
  }),
  resolvedBadgeLabel: _i18n.i18n.translate('xpack.upgradeAssistant.deprecationBadge.resolvedBadgeLabel', {
    defaultMessage: 'Resolved'
  }),
  warningBadgeLabel: _i18n.i18n.translate('xpack.upgradeAssistant.deprecationBadge.warningBadgeLabel', {
    defaultMessage: 'Warning'
  })
};
const DeprecationBadge = ({
  isCritical,
  isResolved
}) => {
  if (isResolved) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success",
      "data-test-subj": "resolvedDeprecationBadge"
    }, i18nTexts.resolvedBadgeLabel);
  }
  if (isCritical) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "danger",
      "data-test-subj": "criticalDeprecationBadge"
    }, i18nTexts.criticalBadgeLabel);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default",
    "data-test-subj": "warningDeprecationBadge"
  }, i18nTexts.warningBadgeLabel);
};
exports.DeprecationBadge = DeprecationBadge;