"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMigrateSystemIndices = void 0;
var _react = require("react");
var _useInterval = _interopRequireDefault(require("react-use/lib/useInterval"));
var _constants = require("../../../../../common/constants");
var _shared_imports = require("../../../../shared_imports");
var _app_context = require("../../../app_context");
var _flyout = require("./flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FLYOUT_ID = 'migrateSystemIndicesFlyout';
const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const useMigrateSystemIndices = () => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [startMigrationStatus, setStartMigrationStatus] = (0, _react.useState)({
    statusType: 'idle'
  });
  const {
    data,
    error,
    isLoading,
    resendRequest,
    isInitialRequest
  } = api.useLoadSystemIndicesMigrationStatus();
  const isInProgress = (data === null || data === void 0 ? void 0 : data.migration_status) === 'IN_PROGRESS';

  // We only want to poll for the status while the migration process is in progress.
  (0, _useInterval.default)(resendRequest, isInProgress ? _constants.SYSTEM_INDICES_MIGRATION_POLL_INTERVAL_MS : null);
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const closeFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(false);
    removeContentFromGlobalFlyout(FLYOUT_ID);
  }, [removeContentFromGlobalFlyout]);
  (0, _react.useEffect)(() => {
    if (showFlyout) {
      addContentToGlobalFlyout({
        id: FLYOUT_ID,
        Component: _flyout.SystemIndicesFlyout,
        props: {
          data: data,
          closeFlyout
        },
        flyoutProps: {
          onClose: closeFlyout
        }
      });
    }
  }, [addContentToGlobalFlyout, data, showFlyout, closeFlyout]);
  const beginSystemIndicesMigration = (0, _react.useCallback)(async () => {
    const {
      error: startMigrationError
    } = await api.migrateSystemIndices();
    setStartMigrationStatus({
      statusType: startMigrationError ? 'error' : 'started',
      error: startMigrationError !== null && startMigrationError !== void 0 ? startMigrationError : undefined
    });
    if (!startMigrationError) {
      resendRequest();
    }
  }, [api, resendRequest]);
  return {
    setShowFlyout,
    startMigrationStatus,
    beginSystemIndicesMigration,
    migrationStatus: {
      data,
      error,
      isLoading,
      resendRequest,
      isInitialRequest
    }
  };
};
exports.useMigrateSystemIndices = useMigrateSystemIndices;