"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDeprecationIssues = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  noPartialDeprecationIssuesText: _i18n.i18n.translate('xpack.upgradeAssistant.noPartialDeprecationsMessage', {
    defaultMessage: 'None'
  }),
  noDeprecationIssuesText: _i18n.i18n.translate('xpack.upgradeAssistant.noDeprecationsMessage', {
    defaultMessage: 'No issues'
  })
};
const NoDeprecationIssues = props => {
  const {
    isPartial = false
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "success"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": props['data-test-subj']
  }, isPartial ? i18nTexts.noPartialDeprecationIssuesText : i18nTexts.noDeprecationIssuesText)));
};
exports.NoDeprecationIssues = NoDeprecationIssues;