"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMlSnapshotContext = exports.MlSnapshotsStatusProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_snapshot_state = require("./use_snapshot_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MlSnapshotsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const useMlSnapshotContext = () => {
  const context = (0, _react.useContext)(MlSnapshotsContext);
  if (context === undefined) {
    throw new Error('useMlSnapshotContext must be used within a <MlSnapshotsStatusProvider />');
  }
  return context;
};
exports.useMlSnapshotContext = useMlSnapshotContext;
const MlSnapshotsStatusProvider = ({
  api,
  snapshotId,
  jobId,
  mlUpgradeModeEnabled,
  children
}) => {
  const {
    updateSnapshotStatus,
    snapshotState,
    upgradeSnapshot,
    deleteSnapshot
  } = (0, _use_snapshot_state.useSnapshotState)({
    jobId,
    snapshotId,
    api
  });
  (0, _react.useEffect)(() => {
    updateSnapshotStatus();
  }, [updateSnapshotStatus]);
  return /*#__PURE__*/_react.default.createElement(MlSnapshotsContext.Provider, {
    value: {
      snapshotState,
      upgradeSnapshot,
      deleteSnapshot,
      mlUpgradeModeEnabled
    }
  }, children);
};
exports.MlSnapshotsStatusProvider = MlSnapshotsStatusProvider;