"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HealthIndicatorTableRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _es_deprecations_table_cells = require("../../es_deprecations_table_cells");
var _flyout = require("./flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const HealthIndicatorTableRow = ({
  rowFieldNames,
  deprecation
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const closeFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(false);
    removeContentFromGlobalFlyout('deprecationDetails');
  }, [removeContentFromGlobalFlyout]);
  (0, _react.useEffect)(() => {
    if (showFlyout) {
      addContentToGlobalFlyout({
        id: 'deprecationDetails',
        Component: _flyout.HealthIndicatorFlyout,
        props: {
          deprecation,
          closeFlyout
        },
        flyoutProps: {
          onClose: closeFlyout,
          className: 'eui-textBreakWord',
          'data-test-subj': 'healthIndicatorDetails',
          'aria-labelledby': 'healthIndicatorDetailsFlyoutTitle'
        }
      });
    }
  }, [addContentToGlobalFlyout, closeFlyout, deprecation, showFlyout]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rowFieldNames.map(field => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      key: field,
      truncateText: false,
      "data-test-subj": `healthIndicatorTableCell-${field}`
    }, /*#__PURE__*/_react.default.createElement(_es_deprecations_table_cells.EsDeprecationsTableCells, {
      fieldName: field,
      deprecation: deprecation,
      openFlyout: () => setShowFlyout(true)
    }));
  }));
};
exports.HealthIndicatorTableRow = HealthIndicatorTableRow;