"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canShowSavedQuery = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// use only if your Kibana app grants this privilege, otherwise default to `globally_managed`

const canShowSavedQuery = ({
  saveQueryMenuVisibility = 'hidden',
  query,
  core
}) => {
  var _core$application$cap;
  // don't show Saved Query menu by default
  if (!saveQueryMenuVisibility || saveQueryMenuVisibility === 'hidden') {
    return false;
  }

  // Saved Queries are not supported for text-based languages (only Saved Searches)
  if ((0, _esQuery.isOfAggregateQueryType)(query)) {
    return false;
  }
  const isAllowedGlobally = Boolean((_core$application$cap = core.application.capabilities.savedQueryManagement) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.saveQuery);

  // users can allow saving queries globally or grant permission per app
  if (saveQueryMenuVisibility === 'allowed_by_app_privilege') {
    return true;
  }
  return isAllowedGlobally;
};
exports.canShowSavedQuery = canShowSavedQuery;