"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedSearchPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _triggers = require("./triggers");
var _services = require("./services");
var _autocomplete_service = require("./autocomplete/autocomplete_service");
var _create_search_bar = require("./search_bar/create_search_bar");
var _index_pattern_select = require("./index_pattern_select");
var _apply_filter_action = require("./actions/apply_filter_action");
var _update_filter_references_action = require("./actions/update_filter_references_action");
var _actions = require("./actions");
var _filters_builder = require("./filters_builder");
require("./index.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class UnifiedSearchPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "storage", void 0);
    (0, _defineProperty2.default)(this, "autocomplete", void 0);
    (0, _defineProperty2.default)(this, "usageCollection", void 0);
    this.storage = new _public.Storage(window.localStorage);
    this.autocomplete = new _autocomplete_service.AutocompleteService(initializerContext);
  }
  setup(core, {
    uiActions,
    data,
    usageCollection
  }) {
    const {
      query
    } = data;
    uiActions.registerTrigger(_triggers.updateFilterReferencesTrigger);
    uiActions.registerAction((0, _apply_filter_action.createFilterAction)(query.filterManager, query.timefilter.timefilter, core.theme));
    uiActions.registerAction((0, _update_filter_references_action.createUpdateFilterReferencesAction)(query.filterManager));
    this.usageCollection = usageCollection;
    return {
      autocomplete: this.autocomplete.setup(core, {
        timefilter: query.timefilter,
        usageCollection
      })
    };
  }
  start(core, {
    data,
    dataViews,
    uiActions,
    screenshotMode
  }) {
    (0, _services.setTheme)(core.theme);
    (0, _services.setOverlays)(core.overlays);
    (0, _services.setIndexPatterns)(dataViews);
    const autocompleteStart = this.autocomplete.start();

    /*
     *
     *  unifiedsearch uses global data service to create stateful search bar.
     *  This function helps in creating a search bar with different instances of data service
     *  so that it can be easy to use multiple stateful searchbars in the single applications
     *
     * */
    const getCustomSearchBar = customDataService => (0, _create_search_bar.createSearchBar)({
      core,
      data: customDataService !== null && customDataService !== void 0 ? customDataService : data,
      storage: this.storage,
      usageCollection: this.usageCollection,
      isScreenshotMode: Boolean(screenshotMode === null || screenshotMode === void 0 ? void 0 : screenshotMode.isScreenshotMode()),
      unifiedSearch: {
        autocomplete: autocompleteStart
      }
    });
    const SearchBar = getCustomSearchBar();
    uiActions.attachAction(_public2.APPLY_FILTER_TRIGGER, _actions.ACTION_GLOBAL_APPLY_FILTER);
    uiActions.attachAction(_triggers.UPDATE_FILTER_REFERENCES_TRIGGER, _actions.UPDATE_FILTER_REFERENCES_ACTION);
    return {
      ui: {
        IndexPatternSelect: (0, _index_pattern_select.createIndexPatternSelect)(dataViews),
        SearchBar,
        getCustomSearchBar,
        AggregateQuerySearchBar: SearchBar,
        FiltersBuilderLazy: _filters_builder.FiltersBuilderLazy
      },
      autocomplete: autocompleteStart
    };
  }
  stop() {
    this.autocomplete.clearProviders();
  }
}
exports.UnifiedSearchPublicPlugin = UnifiedSearchPublicPlugin;