"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _context = require("./context");
var _filter_group = require("./filter_group");
var _reducer = require("./reducer");
var _utils = require("./utils");
var _filters_builder = require("./filters_builder.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const rootLevelConditionType = _esQuery.BooleanRelation.AND;
const DEFAULT_MAX_DEPTH = 10;
function FiltersBuilder({
  onChange,
  dataView,
  filters,
  timeRangeForSuggestionsOverride,
  filtersForSuggestions,
  maxDepth = DEFAULT_MAX_DEPTH,
  hideOr = false,
  disabled = false,
  suggestionsAbstraction,
  filtersCount
}) {
  const filtersRef = (0, _react.useRef)(filters);
  const [state, dispatch] = (0, _react.useReducer)(_reducer.FiltersBuilderReducer, {
    filters
  });
  const [dropTarget, setDropTarget] = (0, _react.useState)('');
  const sPaddingSize = (0, _eui.useEuiPaddingSize)('s');
  (0, _react.useEffect)(() => {
    if (!(0, _esQuery.compareFilters)(filters, filtersRef.current, {
      index: true,
      state: true,
      negate: true,
      disabled: true,
      alias: true
    })) {
      filtersRef.current = filters;
      dispatch({
        type: 'updateFilters',
        payload: {
          filters
        }
      });
    }
  }, [filters]);
  (0, _react.useEffect)(() => {
    if (state.filters !== filtersRef.current) {
      filtersRef.current = state.filters;
      onChange(state.filters);
    }
  }, [onChange, state.filters]);
  const handleMoveFilter = (0, _react.useCallback)((from, to, booleanRelation) => {
    if (from.path === to.path) {
      return null;
    }
    dispatch({
      type: 'moveFilter',
      payload: {
        from,
        to,
        booleanRelation,
        dataView
      }
    });
  }, [dataView]);
  const onDragEnd = args => {
    const {
      combine,
      source,
      destination
    } = args;
    if (source && destination) {
      handleMoveFilter({
        path: source.droppableId,
        index: source.index
      }, {
        path: destination.droppableId,
        index: destination.index
      }, _esQuery.BooleanRelation.AND);
    }
    if (source && combine) {
      var _path$at;
      const path = (0, _utils.getPathInArray)(combine.droppableId);
      handleMoveFilter({
        path: source.droppableId,
        index: source.index
      }, {
        path: combine.droppableId,
        index: (_path$at = path.at(-1)) !== null && _path$at !== void 0 ? _path$at : 0
      }, _esQuery.BooleanRelation.OR);
    }
    setDropTarget('');
  };
  const onDragActive = ({
    destination,
    combine
  }) => {
    if (destination) {
      setDropTarget(destination.droppableId);
    }
    if (combine) {
      setDropTarget(combine.droppableId);
    }
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _filters_builder.filtersBuilderCss)(sPaddingSize)
  }, /*#__PURE__*/_react.default.createElement(_context.FiltersBuilderContextType.Provider, {
    value: {
      globalParams: {
        hideOr,
        maxDepth
      },
      dataView,
      dispatch,
      dropTarget,
      timeRangeForSuggestionsOverride,
      filtersForSuggestions,
      disabled,
      suggestionsAbstraction
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: onDragEnd,
    onDragUpdate: onDragActive
  }, /*#__PURE__*/_react.default.createElement(_filter_group.FilterGroup, {
    filters: state.filters,
    booleanRelation: rootLevelConditionType,
    path: '',
    filtersCount: filtersCount
  }))));
}

// React.lazy support
// eslint-disable-next-line import/no-default-export
var _default = FiltersBuilder;
exports.default = _default;
module.exports = exports.default;