"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _filter_items = _interopRequireDefault(require("./filter_item/filter_items"));
var _filter_bar = require("./filter_bar.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FilterBarUI = /*#__PURE__*/_react.default.memo(function FilterBarUI(props) {
  var _props$className;
  const euiTheme = (0, _eui.useEuiTheme)();
  const styles = (0, _filter_bar.filterBarStyles)(euiTheme, props.afterQueryBar);
  const groupRef = (0, _react.useRef)(null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.group,
    ref: groupRef,
    wrap: true,
    responsive: false,
    gutterSize: "none" // We use `gap` in the styles instead for better truncation of badges
    ,
    alignItems: "center",
    tabIndex: -1,
    "data-test-subj": "filter-items-group",
    className: `filter-items-group ${(_props$className = props.className) !== null && _props$className !== void 0 ? _props$className : ''}`
  }, props.prepend, /*#__PURE__*/_react.default.createElement(_filter_items.default, {
    filters: props.filters,
    onFiltersUpdated: props.onFiltersUpdated,
    indexPatterns: props.indexPatterns,
    timeRangeForSuggestionsOverride: props.timeRangeForSuggestionsOverride,
    filtersForSuggestions: props.filtersForSuggestions,
    hiddenPanelOptions: props.hiddenPanelOptions,
    readOnly: props.isDisabled,
    suggestionsAbstraction: props.suggestionsAbstraction
  }));
});
const FilterBar = (0, _i18nReact.injectI18n)(FilterBarUI);
// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
var _default = FilterBar;
exports.default = _default;
module.exports = exports.default;