"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensSuggestions = void 0;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
var _react = require("react");
var _compute_interval = require("./compute_interval");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TRANSFORMATIONAL_COMMANDS = ['stats', 'project', 'keep'];
const useLensSuggestions = ({
  dataView,
  query,
  originalSuggestion,
  isPlainRecord,
  columns,
  data,
  timeRange,
  lensSuggestionsApi,
  onSuggestionChange
}) => {
  const suggestions = (0, _react.useMemo)(() => {
    var _lensSuggestionsApi;
    const context = {
      dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toSpec(),
      fieldName: '',
      textBasedColumns: columns,
      query: query && (0, _esQuery.isOfAggregateQueryType)(query) ? query : undefined
    };
    const allSuggestions = isPlainRecord ? (_lensSuggestionsApi = lensSuggestionsApi(context, dataView, ['lnsDatatable'])) !== null && _lensSuggestionsApi !== void 0 ? _lensSuggestionsApi : [] : [];
    const [firstSuggestion] = allSuggestions;
    return {
      firstSuggestion,
      allSuggestions
    };
  }, [dataView, isPlainRecord, lensSuggestionsApi, query, columns]);
  const [allSuggestions, setAllSuggestions] = (0, _react.useState)(suggestions.allSuggestions);
  const currentSuggestion = originalSuggestion !== null && originalSuggestion !== void 0 ? originalSuggestion : suggestions.firstSuggestion;
  const suggestionDeps = (0, _react.useRef)(getSuggestionDeps({
    dataView,
    query,
    columns
  }));
  const histogramQuery = (0, _react.useRef)();
  const histogramSuggestion = (0, _react.useMemo)(() => {
    if (!currentSuggestion && dataView.isTimeBased() && query && (0, _esQuery.isOfAggregateQueryType)(query) && (0, _esQuery.getAggregateQueryMode)(query) === 'esql' && timeRange) {
      var _lensSuggestionsApi2;
      let queryHasTransformationalCommands = false;
      if ('esql' in query) {
        TRANSFORMATIONAL_COMMANDS.forEach(command => {
          if (query.esql.toLowerCase().includes(command)) {
            queryHasTransformationalCommands = true;
            return;
          }
        });
      }
      if (queryHasTransformationalCommands) return undefined;
      const interval = (0, _compute_interval.computeInterval)(timeRange, data);
      const language = (0, _esQuery.getAggregateQueryMode)(query);
      const safeQuery = (0, _esQuery.cleanupESQLQueryForLensSuggestions)(query[language]);
      const esqlQuery = `${safeQuery} | EVAL timestamp=DATE_TRUNC(${interval}, ${dataView.timeFieldName}) | stats rows = count(*) by timestamp | rename timestamp as \`${dataView.timeFieldName} every ${interval}\``;
      const context = {
        dataViewSpec: dataView === null || dataView === void 0 ? void 0 : dataView.toSpec(),
        fieldName: '',
        textBasedColumns: [{
          id: `${dataView.timeFieldName} every ${interval}`,
          name: `${dataView.timeFieldName} every ${interval}`,
          meta: {
            type: 'date'
          }
        }, {
          id: 'rows',
          name: 'rows',
          meta: {
            type: 'number'
          }
        }],
        query: {
          esql: esqlQuery
        }
      };
      const sug = (_lensSuggestionsApi2 = lensSuggestionsApi(context, dataView, ['lnsDatatable'])) !== null && _lensSuggestionsApi2 !== void 0 ? _lensSuggestionsApi2 : [];
      if (sug.length) {
        histogramQuery.current = {
          esql: esqlQuery
        };
        return sug[0];
      }
    }
    histogramQuery.current = undefined;
    return undefined;
  }, [currentSuggestion, dataView, query, timeRange, data, lensSuggestionsApi]);
  (0, _react.useEffect)(() => {
    const newSuggestionsDeps = getSuggestionDeps({
      dataView,
      query,
      columns
    });
    if (!(0, _lodash.isEqual)(suggestionDeps.current, newSuggestionsDeps)) {
      setAllSuggestions(suggestions.allSuggestions);
      onSuggestionChange === null || onSuggestionChange === void 0 ? void 0 : onSuggestionChange(suggestions.firstSuggestion);
      suggestionDeps.current = newSuggestionsDeps;
    }
  }, [columns, dataView, onSuggestionChange, query, suggestions.firstSuggestion, suggestions.allSuggestions]);
  return {
    allSuggestions,
    currentSuggestion: histogramSuggestion !== null && histogramSuggestion !== void 0 ? histogramSuggestion : currentSuggestion,
    suggestionUnsupported: !currentSuggestion && !histogramSuggestion && isPlainRecord,
    isOnHistogramMode: Boolean(histogramSuggestion),
    histogramQuery: histogramQuery.current ? histogramQuery.current : undefined
  };
};
exports.useLensSuggestions = useLensSuggestions;
const getSuggestionDeps = ({
  dataView,
  query,
  columns
}) => [dataView.id, columns, query];