"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setTopPanelHeight = exports.setChartHidden = exports.setBreakdownField = exports.getTopPanelHeight = exports.getChartHidden = exports.getBreakdownField = exports.HISTOGRAM_HEIGHT_KEY = exports.HISTOGRAM_BREAKDOWN_FIELD_KEY = exports.CHART_HIDDEN_KEY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CHART_HIDDEN_KEY = 'chartHidden';
exports.CHART_HIDDEN_KEY = CHART_HIDDEN_KEY;
const HISTOGRAM_HEIGHT_KEY = 'histogramHeight';
exports.HISTOGRAM_HEIGHT_KEY = HISTOGRAM_HEIGHT_KEY;
const HISTOGRAM_BREAKDOWN_FIELD_KEY = 'histogramBreakdownField';
exports.HISTOGRAM_BREAKDOWN_FIELD_KEY = HISTOGRAM_BREAKDOWN_FIELD_KEY;
const getLocalStorageKey = (prefix, key) => `${prefix}:${key}`;

/**
 * Get the chart hidden state from local storage
 */
const getChartHidden = (storage, localStorageKeyPrefix) => storage.get(getLocalStorageKey(localStorageKeyPrefix, CHART_HIDDEN_KEY));

/**
 * Get the top panel height from local storage
 */
exports.getChartHidden = getChartHidden;
const getTopPanelHeight = (storage, localStorageKeyPrefix) => {
  var _storage$get;
  return (_storage$get = storage.get(getLocalStorageKey(localStorageKeyPrefix, HISTOGRAM_HEIGHT_KEY))) !== null && _storage$get !== void 0 ? _storage$get : undefined;
};

/**
 * Get the breakdown field from local storage
 */
exports.getTopPanelHeight = getTopPanelHeight;
const getBreakdownField = (storage, localStorageKeyPrefix) => {
  var _storage$get2;
  return (_storage$get2 = storage.get(getLocalStorageKey(localStorageKeyPrefix, HISTOGRAM_BREAKDOWN_FIELD_KEY))) !== null && _storage$get2 !== void 0 ? _storage$get2 : undefined;
};

/**
 * Set the chart hidden state in local storage
 */
exports.getBreakdownField = getBreakdownField;
const setChartHidden = (storage, localStorageKeyPrefix, chartHidden) => storage.set(getLocalStorageKey(localStorageKeyPrefix, CHART_HIDDEN_KEY), chartHidden);

/**
 * Set the top panel height in local storage
 */
exports.setChartHidden = setChartHidden;
const setTopPanelHeight = (storage, localStorageKeyPrefix, topPanelHeight) => storage.set(getLocalStorageKey(localStorageKeyPrefix, HISTOGRAM_HEIGHT_KEY), topPanelHeight);

/**
 * Set the breakdown field in local storage
 */
exports.setTopPanelHeight = setTopPanelHeight;
const setBreakdownField = (storage, localStorageKeyPrefix, breakdownField) => storage.set(getLocalStorageKey(localStorageKeyPrefix, HISTOGRAM_BREAKDOWN_FIELD_KEY), breakdownField);
exports.setBreakdownField = setBreakdownField;