"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.UnifiedHistogramContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _layout = require("../layout");
var _state_service = require("./services/state_service");
var _use_state_props = require("./hooks/use_state_props");
var _use_state_selector = require("./utils/use_state_selector");
var _state_selectors = require("./utils/state_selectors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * The options used to initialize the container
 */

/**
 * The props exposed by the container
 */

/**
 * The API exposed by the container
 */

const UnifiedHistogramContainer = /*#__PURE__*/(0, _react.forwardRef)((containerProps, ref) => {
  const [layoutProps, setLayoutProps] = (0, _react.useState)();
  const [stateService, setStateService] = (0, _react.useState)();
  const [lensSuggestionsApi, setLensSuggestionsApi] = (0, _react.useState)();
  const [input$] = (0, _react.useState)(() => new _rxjs.Subject());
  const [api, setApi] = (0, _react.useState)();

  // Expose the API to the parent component
  (0, _react.useImperativeHandle)(ref, () => api, [api]);

  // Call for creation options once the container is mounted
  (0, _useMount.default)(async () => {
    const {
      getCreationOptions,
      services
    } = containerProps;
    const options = await (getCreationOptions === null || getCreationOptions === void 0 ? void 0 : getCreationOptions());
    const apiHelper = await services.lens.stateHelperApi();
    setLayoutProps((0, _lodash.pick)(options, 'disableAutoFetching', 'disableTriggers', 'disabledActions'));
    setStateService((0, _state_service.createStateService)({
      services,
      ...options
    }));
    setLensSuggestionsApi(() => apiHelper.suggestions);
  });

  // Initialize the API once the state service is available
  (0, _react.useEffect)(() => {
    if (!stateService) {
      return;
    }
    setApi({
      refetch: () => {
        input$.next({
          type: 'refetch'
        });
      },
      ...(0, _lodash.pick)(stateService, 'state$', 'setChartHidden', 'setTopPanelHeight', 'setBreakdownField', 'setTimeInterval', 'setTotalHits')
    });
  }, [input$, stateService]);
  const {
    dataView,
    query,
    searchSessionId,
    requestAdapter,
    isChartLoading
  } = containerProps;
  const currentSuggestion = (0, _use_state_selector.useStateSelector)(stateService === null || stateService === void 0 ? void 0 : stateService.state$, _state_selectors.currentSuggestionSelector);
  const topPanelHeight = (0, _use_state_selector.useStateSelector)(stateService === null || stateService === void 0 ? void 0 : stateService.state$, _state_selectors.topPanelHeightSelector);
  const stateProps = (0, _use_state_props.useStateProps)({
    stateService,
    dataView,
    query,
    searchSessionId,
    requestAdapter
  });

  // Don't render anything until the container is initialized
  if (!layoutProps || !lensSuggestionsApi || !api) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_layout.UnifiedHistogramLayout, (0, _extends2.default)({}, containerProps, layoutProps, stateProps, {
    currentSuggestion: currentSuggestion,
    isChartLoading: Boolean(isChartLoading),
    topPanelHeight: topPanelHeight,
    input$: input$,
    lensSuggestionsApi: lensSuggestionsApi
  }));
});

// eslint-disable-next-line import/no-default-export
exports.UnifiedHistogramContainer = UnifiedHistogramContainer;
var _default = UnifiedHistogramContainer;
exports.default = _default;