"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableFieldValue = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _discoverUtils = require("@kbn/discover-utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const IgnoreWarning = /*#__PURE__*/_react2.default.memo(({
  rawValue,
  reason
}) => {
  const multiValue = Array.isArray(rawValue) && rawValue.length > 1;
  const getToolTipContent = () => {
    switch (reason) {
      case _discoverUtils.IgnoredReason.IGNORE_ABOVE:
        return multiValue ? _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.multiAboveTooltip', {
          defaultMessage: `One or more values in this field are too long and can't be searched or filtered.`
        }) : _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.singleAboveTooltip', {
          defaultMessage: `The value in this field is too long and can't be searched or filtered.`
        });
      case _discoverUtils.IgnoredReason.MALFORMED:
        return multiValue ? _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.multiMalformedTooltip', {
          defaultMessage: `This field has one or more malformed values that can't be searched or filtered.`
        }) : _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.singleMalformedTooltip', {
          defaultMessage: `The value in this field is malformed and can't be searched or filtered.`
        });
      case _discoverUtils.IgnoredReason.UNKNOWN:
        return multiValue ? _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.multiUnknownTooltip', {
          defaultMessage: `One or more values in this field were ignored by Elasticsearch and can't be searched or filtered.`
        }) : _i18n.i18n.translate('unifiedDocViewer.docView.table.ignored.singleUnknownTooltip', {
          defaultMessage: `The value in this field was ignored by Elasticsearch and can't be searched or filtered.`
        });
    }
  };
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: getToolTipContent()
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    responsive: false,
    alignItems: "center",
    css: (0, _react.css)`
          cursor: help;
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
    color: "warning"
  }, multiValue ? _i18n.i18n.translate('unifiedDocViewer.docViews.table.ignored.multiValueLabel', {
    defaultMessage: 'Contains ignored values'
  }) : _i18n.i18n.translate('unifiedDocViewer.docViews.table.ignored.singleValueLabel', {
    defaultMessage: 'Ignored value'
  })))));
});
const TableFieldValue = ({
  formattedValue,
  field,
  rawValue,
  ignoreReason
}) => {
  const valueClassName = (0, _classnames.default)({
    // eslint-disable-next-line @typescript-eslint/naming-convention
    kbnDocViewer__value: true
  });
  return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, null, ignoreReason && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, ignoreReason && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(IgnoreWarning, {
    reason: ignoreReason,
    rawValue: rawValue
  }))), /*#__PURE__*/_react2.default.createElement("div", {
    className: valueClassName,
    "data-test-subj": `tableDocViewRow-${field}-value`
    // Value returned from formatFieldValue is always sanitized
    // eslint-disable-next-line react/no-danger
    ,
    dangerouslySetInnerHTML: {
      __html: formattedValue
    }
  }));
};
exports.TableFieldValue = TableFieldValue;