"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TableActions = ({
  mode = 'as_popover',
  pinned,
  field,
  fieldMapping,
  flattenedField,
  onToggleColumn,
  onFilter,
  ignoredValue,
  onTogglePinned
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const openActionsLabel = _i18n.i18n.translate('unifiedDocViewer.docView.table.actions.open', {
    defaultMessage: 'Open actions'
  });
  const actionsLabel = _i18n.i18n.translate('unifiedDocViewer.docView.table.actions.label', {
    defaultMessage: 'Actions'
  });

  // Filters pair
  const filtersPairDisabled = !fieldMapping || !fieldMapping.filterable || ignoredValue || !onFilter;
  const filterAddLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.filterForValueButtonTooltip', {
    defaultMessage: 'Filter for value'
  });
  const filterAddAriaLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.filterForValueButtonAriaLabel', {
    defaultMessage: 'Filter for value'
  });
  const filterOutLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.filterOutValueButtonTooltip', {
    defaultMessage: 'Filter out value'
  });
  const filterOutAriaLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.filterOutValueButtonAriaLabel', {
    defaultMessage: 'Filter out value'
  });
  const filtersPairToolTip = filtersPairDisabled && _i18n.i18n.translate('unifiedDocViewer.docViews.table.unindexedFieldsCanNotBeSearchedTooltip', {
    defaultMessage: 'Unindexed fields or ignored values cannot be searched'
  }) || undefined;

  // Filter exists
  const filterExistsLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.filterForFieldPresentButtonTooltip', {
    defaultMessage: 'Filter for field present'
  });
  const filterExistsAriaLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.filterForFieldPresentButtonAriaLabel', {
    defaultMessage: 'Filter for field present'
  });
  const filtersExistsDisabled = !fieldMapping || !fieldMapping.filterable || !onFilter;
  const filtersExistsToolTip = filtersExistsDisabled && (fieldMapping && fieldMapping.scripted ? _i18n.i18n.translate('unifiedDocViewer.docViews.table.unableToFilterForPresenceOfScriptedFieldsTooltip', {
    defaultMessage: 'Unable to filter for presence of scripted fields'
  }) : _i18n.i18n.translate('unifiedDocViewer.docViews.table.unableToFilterForPresenceOfMetaFieldsTooltip', {
    defaultMessage: 'Unable to filter for presence of meta fields'
  })) || undefined;

  // Toggle columns
  const toggleColumnsLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.toggleColumnInTableButtonTooltip', {
    defaultMessage: 'Toggle column in table'
  });
  const toggleColumnsAriaLabel = _i18n.i18n.translate('unifiedDocViewer.docViews.table.toggleColumnInTableButtonAriaLabel', {
    defaultMessage: 'Toggle column in table'
  });

  // Pinned
  const pinnedLabel = pinned ? _i18n.i18n.translate('unifiedDocViewer.docViews.table.unpinFieldLabel', {
    defaultMessage: 'Unpin field'
  }) : _i18n.i18n.translate('unifiedDocViewer.docViews.table.pinFieldLabel', {
    defaultMessage: 'Pin field'
  });
  const pinnedAriaLabel = pinned ? _i18n.i18n.translate('unifiedDocViewer.docViews.table.unpinFieldAriaLabel', {
    defaultMessage: 'Unpin field'
  }) : _i18n.i18n.translate('unifiedDocViewer.docViews.table.pinFieldAriaLabel', {
    defaultMessage: 'Pin field'
  });
  const pinnedIconType = pinned ? 'pinFilled' : 'pin';
  const toggleOpenPopover = (0, _react.useCallback)(() => setIsOpen(current => !current), []);
  const closePopover = (0, _react.useCallback)(() => setIsOpen(false), []);
  const togglePinned = (0, _react.useCallback)(() => onTogglePinned(field), [field, onTogglePinned]);
  const onClickAction = (0, _react.useCallback)(callback => () => {
    callback();
    closePopover();
  }, [closePopover]);
  const panels = [{
    id: 0,
    title: actionsLabel,
    items: [{
      name: filterAddLabel,
      'aria-label': filterAddAriaLabel,
      toolTipContent: filtersPairToolTip,
      icon: 'plusInCircle',
      disabled: filtersPairDisabled,
      'data-test-subj': `addFilterForValueButton-${field}`,
      onClick: onFilter ? onClickAction(onFilter.bind({}, fieldMapping, flattenedField, '+')) : undefined
    }, {
      name: filterOutLabel,
      'aria-label': filterOutAriaLabel,
      toolTipContent: filtersPairToolTip,
      icon: 'minusInCircle',
      disabled: filtersPairDisabled,
      'data-test-subj': `addFilterOutValueButton-${field}`,
      onClick: onFilter ? onClickAction(onFilter.bind({}, fieldMapping, flattenedField, '-')) : undefined
    }, {
      name: filterExistsLabel,
      'aria-label': filterExistsAriaLabel,
      toolTipContent: filtersExistsToolTip,
      icon: 'filter',
      disabled: filtersExistsDisabled,
      'data-test-subj': `addExistsFilterButton-${field}`,
      onClick: onFilter ? onClickAction(onFilter.bind({}, '_exists_', field, '+')) : undefined
    }, {
      name: toggleColumnsLabel,
      'aria-label': toggleColumnsAriaLabel,
      'data-test-subj': `toggleColumnButton-${field}`,
      icon: 'listAdd',
      onClick: onClickAction(onToggleColumn.bind({}, field))
    }, {
      name: pinnedLabel,
      'aria-label': pinnedAriaLabel,
      icon: pinnedIconType,
      'data-test-subj': `togglePinFilterButton-${field}`,
      onClick: onClickAction(togglePinned)
    }]
  }];
  if (mode === 'inline') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      className: "kbnDocViewer__buttons",
      "data-test-subj": `fieldActionsGroup-${field}`
    }, panels[0].items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: item.icon,
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: item.name
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      className: "kbnDocViewer__actionButton",
      "data-test-subj": item['data-test-subj'],
      "aria-label": item['aria-label'],
      iconType: item.icon,
      iconSize: "s",
      disabled: item.disabled,
      onClick: item.onClick
    })))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `openFieldActionsButton-${field}`,
      "aria-label": openActionsLabel,
      onClick: toggleOpenPopover,
      iconType: "boxesHorizontal",
      color: "text"
    }),
    isOpen: isOpen,
    closePopover: closePopover,
    display: "block",
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    size: "s",
    panels: panels
  }));
};
exports.TableActions = TableActions;