"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionFactoryPicker = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _action_factory_picker = require("../../../../components/action_factory_picker");
var _context = require("../context");
var _action_factory_view = require("../action_factory_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ActionFactoryPicker = ({}) => {
  const drilldowns = (0, _context.useDrilldownManager)();
  const factory = drilldowns.useActionFactory();
  const context = _react.default.useMemo(() => drilldowns.getActionFactoryContext(), [drilldowns]);
  const compatibleFactories = drilldowns.useCompatibleActionFactories(context);
  if (!!factory) {
    return /*#__PURE__*/_react.default.createElement(_action_factory_view.ActionFactoryView, {
      factory: factory,
      context: context
    });
  }
  if (!compatibleFactories) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_action_factory_picker.ActionFactoryPicker, {
    actionFactories: compatibleFactories,
    context: context,
    onSelect: actionFactory => {
      drilldowns.setActionFactory(actionFactory);
    }
  });
};
exports.ActionFactoryPicker = ActionFactoryPicker;