"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEST_SUBJ_DRILLDOWN_ITEM = exports.DrilldownTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _text_with_icon = require("../text_with_icon");
var _trigger_line_item = require("../trigger_line_item");
var _i18n = require("./i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TEST_SUBJ_DRILLDOWN_ITEM = 'listManageDrilldownsItem';
exports.TEST_SUBJ_DRILLDOWN_ITEM = TEST_SUBJ_DRILLDOWN_ITEM;
const DrilldownTable = ({
  items: drilldowns,
  onCreate,
  onDelete,
  onEdit,
  onCopy
}) => {
  const [selectedDrilldowns, setSelectedDrilldowns] = (0, _react.useState)([]);
  const columns = [{
    field: 'drilldownName',
    name: _i18n.txtName,
    sortable: true,
    'data-test-subj': 'drilldownListItemName',
    render: (drilldownName, drilldown) => /*#__PURE__*/_react.default.createElement("div", null, drilldownName, ' ', drilldown.error && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      id: `drilldownError-${drilldown.id}`,
      content: drilldown.error
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "danger",
      title: drilldown.error,
      "aria-label": drilldown.error,
      "data-test-subj": `drilldownError-${drilldown.id}`,
      style: {
        marginLeft: '4px'
      } /* a bit of spacing from text */
    })))
  }, {
    name: _i18n.txtAction,
    render: drilldown => /*#__PURE__*/_react.default.createElement(_text_with_icon.TextWithIcon, {
      icon: drilldown.icon,
      color: 'subdued'
    }, drilldown.actionName)
  }, {
    field: 'triggers',
    name: _i18n.txtTrigger,
    textOnly: true,
    sortable: drilldown => drilldown.triggers ? drilldown.triggers[0].title : '',
    render: (triggers, drilldown) => {
      var _trigger$title;
      if (!drilldown.triggers) return null;
      const trigger = drilldown.triggers[0];
      return /*#__PURE__*/_react.default.createElement(_trigger_line_item.TriggerLineItem, {
        incompatible: drilldown.triggerIncompatible,
        tooltip: trigger.description
      }, (_trigger$title = trigger.title) !== null && _trigger$title !== void 0 ? _trigger$title : 'unknown');
    }
  }, {
    align: 'right',
    render: drilldown => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!onEdit && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      disabled: !!selectedDrilldowns.length,
      onClick: () => onEdit(drilldown.id)
    }, _i18n.txtEditDrilldown), !!onCopy && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      disabled: !!selectedDrilldowns.length,
      onClick: () => onCopy(drilldown.id)
    }, _i18n.txtCloneDrilldown))
  }].filter(Boolean);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: drilldowns,
    itemId: "id",
    columns: columns,
    isSelectable: true,
    responsive: false,
    selection: {
      onSelectionChange: selection => {
        setSelectedDrilldowns(selection.map(drilldown => drilldown.id));
      },
      selectableMessage: () => _i18n.txtSelectDrilldown
    },
    rowProps: {
      'data-test-subj': TEST_SUBJ_DRILLDOWN_ITEM
    },
    hasActions: true,
    sorting: {
      sort: {
        field: 'drilldownName',
        direction: 'asc'
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), !!onCreate && !selectedDrilldowns.length && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: () => onCreate()
  }, _i18n.txtCreateDrilldown), !!onDelete && selectedDrilldowns.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    fill: true,
    onClick: () => onDelete(selectedDrilldowns),
    "data-test-subj": 'listManageDeleteDrilldowns'
  }, (0, _i18n.txtDeleteDrilldowns)(selectedDrilldowns.length)));
};
exports.DrilldownTable = DrilldownTable;