"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesListNotifyBadgeWithApi = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../../common/lib/kibana");
var _unsnooze = require("../../../../lib/rule_api/unsnooze");
var _snooze = require("../../../../lib/rule_api/snooze");
var _notify_badge = require("./notify_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesListNotifyBadgeWithApi = ({
  ruleId,
  snoozeSettings,
  loading,
  disabled,
  showTooltipInline,
  showOnHover,
  onRuleChanged
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const onSnoozeRule = (0, _react.useCallback)(snoozeSchedule => ruleId ? (0, _snooze.snoozeRule)({
    http,
    id: ruleId,
    snoozeSchedule
  }) : Promise.resolve(), [http, ruleId]);
  const onUnsnoozeRule = (0, _react.useCallback)(scheduleIds => ruleId ? (0, _unsnooze.unsnoozeRule)({
    http,
    id: ruleId,
    scheduleIds
  }) : Promise.resolve(), [http, ruleId]);
  return /*#__PURE__*/_react.default.createElement(_notify_badge.RulesListNotifyBadge, {
    snoozeSettings: snoozeSettings,
    loading: loading,
    disabled: disabled,
    onRuleChanged: onRuleChanged,
    snoozeRule: onSnoozeRule,
    unsnoozeRule: onUnsnoozeRule,
    showTooltipInline: showTooltipInline,
    showOnHover: showOnHover
  });
};
exports.RulesListNotifyBadgeWithApi = RulesListNotifyBadgeWithApi;