"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmRuleClose = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmRuleClose = ({
  onConfirm,
  onCancel
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmRuleClose.confirmRuleCloseTitle', {
      defaultMessage: 'Discard unsaved changes to rule?'
    }),
    onCancel: onCancel,
    onConfirm: onConfirm,
    buttonColor: "danger",
    confirmButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmRuleClose.confirmRuleCloseConfirmButtonText', {
      defaultMessage: 'Discard changes'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.triggersActionsUI.sections.confirmRuleClose.confirmRuleCloseCancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    defaultFocusedButton: "confirm",
    "data-test-subj": "confirmRuleCloseModal"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.confirmRuleClose.confirmRuleCloseMessage",
    defaultMessage: "You can't recover unsaved changes."
  })));
};
exports.ConfirmRuleClose = ConfirmRuleClose;