"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.GlobalRuleEventLogList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rule_event_log_list_table = require("./rule_event_log_list_table");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const GLOBAL_EVENT_LOG_LIST_STORAGE_KEY = 'xpack.triggersActionsUI.globalEventLogList.initialColumns';
const REFRESH_TOKEN = {
  resolve: () => {
    /* noop */
  },
  reject: () => {
    /* noop */
  }
};
const GlobalRuleEventLogList = props => {
  const {
    setHeaderActions,
    localStorageKey,
    filteredRuleTypes,
    getRuleDetailsRoute
  } = props;
  const {
    spaces
  } = (0, _kibana.useKibana)().services;

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const SpacesContextWrapper = (0, _react.useCallback)(spaces ? spaces.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spaces]);
  return /*#__PURE__*/_react.default.createElement(SpacesContextWrapper, {
    feature: "triggersActions"
  }, /*#__PURE__*/_react.default.createElement(_rule_event_log_list_table.RuleEventLogListTable, {
    ruleId: '*',
    refreshToken: REFRESH_TOKEN,
    initialPageSize: 50,
    hasRuleNames: true,
    hasAllSpaceSwitch: true,
    localStorageKey: localStorageKey || GLOBAL_EVENT_LOG_LIST_STORAGE_KEY,
    filteredRuleTypes: filteredRuleTypes,
    setHeaderActions: setHeaderActions,
    getRuleDetailsRoute: getRuleDetailsRoute
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.GlobalRuleEventLogList = GlobalRuleEventLogList;