"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewRuleDetailsAlertAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MenuItem = (0, _styled.default)(_eui.EuiContextMenuItem)`
  &:hover {
    text-decoration: underline;
  }
`;

/**
 * Alerts table row action to open the rule to which the selected alert is associated
 */
const ViewRuleDetailsAlertAction = /*#__PURE__*/(0, _react.memo)(({
  alert,
  resolveRulePagePath,
  id: pageId
}) => {
  var _alert$ALERT_RULE_UUI, _alert$ALERT_RULE_UUI2;
  const {
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana.useKibana)().services;
  const ruleId = (_alert$ALERT_RULE_UUI = (_alert$ALERT_RULE_UUI2 = alert[_ruleDataUtils.ALERT_RULE_UUID]) === null || _alert$ALERT_RULE_UUI2 === void 0 ? void 0 : _alert$ALERT_RULE_UUI2[0]) !== null && _alert$ALERT_RULE_UUI !== void 0 ? _alert$ALERT_RULE_UUI : null;
  const pagePath = ruleId && pageId && (resolveRulePagePath === null || resolveRulePagePath === void 0 ? void 0 : resolveRulePagePath(ruleId, pageId));
  const linkToRule = pagePath ? prepend(pagePath) : null;
  if (!linkToRule) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(MenuItem, {
    "data-test-subj": "viewRuleDetails",
    key: "viewRuleDetails",
    href: linkToRule,
    size: "s"
  }, _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.viewRuleDetails', {
    defaultMessage: 'View rule details'
  }));
});
exports.ViewRuleDetailsAlertAction = ViewRuleDetailsAlertAction;