"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkAsUntrackedAlertAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _ = require("../../../..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Alerts table row action to mark the selected alert as untracked
 */
const MarkAsUntrackedAlertAction = /*#__PURE__*/(0, _react.memo)(({
  alert,
  refresh,
  onActionExecuted
}) => {
  const {
    mutateAsync: untrackAlerts
  } = (0, _.useBulkUntrackAlerts)();
  const isAlertActive = (0, _react.useMemo)(() => {
    var _alert$ALERT_STATUS;
    return ((_alert$ALERT_STATUS = alert[_ruleDataUtils.ALERT_STATUS]) === null || _alert$ALERT_STATUS === void 0 ? void 0 : _alert$ALERT_STATUS[0]) === _ruleDataUtils.ALERT_STATUS_ACTIVE;
  }, [alert]);
  const handleUntrackAlert = (0, _react.useCallback)(async () => {
    var _alert$_index;
    await untrackAlerts({
      indices: [(_alert$_index = alert._index) !== null && _alert$_index !== void 0 ? _alert$_index : ''],
      alertUuids: [alert._id]
    });
    onActionExecuted === null || onActionExecuted === void 0 ? void 0 : onActionExecuted();
    refresh();
  }, [untrackAlerts, alert._index, alert._id, onActionExecuted, refresh]);
  if (!isAlertActive) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "untrackAlert",
    key: "untrackAlert",
    size: "s",
    onClick: handleUntrackAlert
  }, _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.actions.untrack', {
    defaultMessage: 'Mark as untracked'
  }));
});
exports.MarkAsUntrackedAlertAction = MarkAsUntrackedAlertAction;