"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaintenanceWindowCell = exports.MaintenanceWindowBaseCell = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _tooltip_content = require("./tooltip_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isMaintenanceWindowValid = mw => {
  return !!mw;
};
const MaintenanceWindowBaseCell = /*#__PURE__*/(0, _react.memo)(props => {
  const {
    maintenanceWindows,
    maintenanceWindowIds,
    isLoading,
    timestamp
  } = props;
  const tooltipWithText = (0, _react.useMemo)(() => {
    const totalLength = maintenanceWindows.length + maintenanceWindowIds.length;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, maintenanceWindows.map((mw, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      key: `${mw.id}_tooltip`,
      content: /*#__PURE__*/_react.default.createElement(_tooltip_content.TooltipContent, {
        maintenanceWindow: mw,
        timestamp: timestamp
      })
    }, /*#__PURE__*/_react.default.createElement("span", {
      key: `${mw.id}_title`
    }, mw.title, index !== totalLength - 1 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ", \xA0"))))), maintenanceWindowIds.map((id, index) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
      key: `${id}_id`
    }, id, index + maintenanceWindows.length !== totalLength - 1 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ", \xA0")))));
  }, [maintenanceWindows, maintenanceWindowIds, timestamp]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "maintenance-window-cell-loading",
    lines: 1,
    isLoading: isLoading,
    size: "s"
  }, tooltipWithText);
});
exports.MaintenanceWindowBaseCell = MaintenanceWindowBaseCell;
const MaintenanceWindowCell = /*#__PURE__*/(0, _react.memo)(props => {
  var _alert$TIMESTAMP;
  const {
    alert,
    maintenanceWindows,
    isLoading
  } = props;
  const validMaintenanceWindows = (0, _react.useMemo)(() => {
    const maintenanceWindowIds = alert[_ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS] || [];
    return maintenanceWindowIds.map(id => maintenanceWindows.get(id)).filter(isMaintenanceWindowValid);
  }, [alert, maintenanceWindows]);
  const idsWithoutMaintenanceWindow = (0, _react.useMemo)(() => {
    const maintenanceWindowIds = alert[_ruleDataUtils.ALERT_MAINTENANCE_WINDOW_IDS] || [];
    return maintenanceWindowIds.filter(id => !maintenanceWindows.get(id));
  }, [alert, maintenanceWindows]);
  if (validMaintenanceWindows.length === 0 && idsWithoutMaintenanceWindow.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "--");
  }
  return /*#__PURE__*/_react.default.createElement(MaintenanceWindowBaseCell, {
    maintenanceWindows: validMaintenanceWindows,
    maintenanceWindowIds: idsWithoutMaintenanceWindow,
    isLoading: isLoading,
    timestamp: (_alert$TIMESTAMP = alert[_ruleDataUtils.TIMESTAMP]) === null || _alert$TIMESTAMP === void 0 ? void 0 : _alert$TIMESTAMP[0]
  });
});
exports.MaintenanceWindowCell = MaintenanceWindowCell;
MaintenanceWindowCell.displayName = 'maintenanceWindowCell';