"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkGetMaintenanceWindows = void 0;
var _common = require("@kbn/alerting-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rewriteMaintenanceWindowRes = ({
  expiration_date: expirationDate,
  r_rule: rRule,
  created_by: createdBy,
  updated_by: updatedBy,
  created_at: createdAt,
  updated_at: updatedAt,
  event_start_time: eventStartTime,
  event_end_time: eventEndTime,
  category_ids: categoryIds,
  ...rest
}) => ({
  ...rest,
  expirationDate,
  rRule,
  createdBy,
  updatedBy,
  createdAt,
  updatedAt,
  eventStartTime,
  eventEndTime,
  categoryIds
});
const rewriteErrorRes = ({
  status_code: statusCode,
  ...rest
}) => ({
  ...rest,
  statusCode
});
const rewriteBodyRes = response => {
  return {
    maintenanceWindows: response.maintenance_windows.map(mw => rewriteMaintenanceWindowRes(mw)),
    errors: response.errors.map(error => rewriteErrorRes(error))
  };
};
const bulkGetMaintenanceWindows = async ({
  http,
  ids
}) => {
  const res = await http.post(`${_common.INTERNAL_ALERTING_API_MAINTENANCE_WINDOW_PATH}/_bulk_get`, {
    body: JSON.stringify({
      ids
    })
  });
  return rewriteBodyRes(res);
};
exports.bulkGetMaintenanceWindows = bulkGetMaintenanceWindows;