"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AlertSummaryWidget = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_load_alert_summary = require("../../hooks/use_load_alert_summary");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertSummaryWidget = ({
  chartProps,
  featureIds,
  filter,
  fullSize,
  onClick = () => {},
  timeRange,
  hideChart,
  onLoaded
}) => {
  const {
    alertSummary: {
      activeAlertCount,
      activeAlerts,
      recoveredAlertCount
    },
    isLoading,
    error
  } = (0, _use_load_alert_summary.useLoadAlertSummary)({
    featureIds,
    filter,
    timeRange
  });
  (0, _react.useEffect)(() => {
    if (!isLoading && onLoaded) {
      onLoaded();
    }
  }, [isLoading, onLoaded]);
  if (isLoading) return /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetLoader, {
    fullSize: fullSize,
    isLoadingWithoutChart: hideChart
  });
  if (error) return /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetError, null);
  return fullSize ?
  // Only show full size version if there is data
  activeAlertCount || recoveredAlertCount ? /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetFullSize, {
    activeAlertCount: activeAlertCount,
    activeAlerts: activeAlerts,
    chartProps: chartProps,
    dateFormat: timeRange.dateFormat,
    recoveredAlertCount: recoveredAlertCount,
    hideChart: hideChart
  }) : null : /*#__PURE__*/_react.default.createElement(_components.AlertSummaryWidgetCompact, {
    activeAlertCount: activeAlertCount,
    activeAlerts: activeAlerts,
    chartProps: chartProps,
    onClick: onClick,
    recoveredAlertCount: recoveredAlertCount,
    timeRangeTitle: timeRange.title
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.AlertSummaryWidget = AlertSummaryWidget;