"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionAlertsFilterQuery = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _alerts_search_bar = require("../alerts_search_bar");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActionAlertsFilterQuery = ({
  state,
  onChange,
  appName,
  featureIds,
  ruleTypeId
}) => {
  var _query$filters;
  const [query, setQuery] = (0, _react.useState)(state !== null && state !== void 0 ? state : {
    kql: '',
    filters: []
  });
  const queryEnabled = (0, _react.useMemo)(() => Boolean(state), [state]);
  (0, _react.useEffect)(() => {
    const nextState = queryEnabled ? query : undefined;
    if (!(0, _fastDeepEqual.default)(state, nextState)) onChange(nextState);
  }, [queryEnabled, query, state, onChange]);
  const toggleQuery = (0, _react.useCallback)(() => onChange(state ? undefined : query), [state, query, onChange]);
  const updateQuery = (0, _react.useCallback)(update => {
    setQuery({
      ...query,
      ...update
    });
  }, [query, setQuery]);
  const onQueryChange = (0, _react.useCallback)(({
    query: newQuery
  }) => updateQuery({
    kql: newQuery
  }), [updateQuery]);
  const onFiltersUpdated = (0, _react.useCallback)(filters => updateQuery({
    filters
  }), [updateQuery]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.ActionAlertsFilterQueryToggleLabel', {
      defaultMessage: 'If alert matches a query'
    }),
    checked: queryEnabled,
    onChange: toggleQuery,
    "data-test-subj": "alertsFilterQueryToggle"
  }), queryEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_alerts_search_bar.AlertsSearchBar, {
    appName: appName,
    featureIds: featureIds,
    ruleTypeId: ruleTypeId,
    disableQueryLanguageSwitcher: true,
    query: query.kql,
    filters: (_query$filters = query.filters) !== null && _query$filters !== void 0 ? _query$filters : [],
    onQueryChange: onQueryChange,
    onQuerySubmit: onQueryChange,
    onFiltersUpdated: onFiltersUpdated,
    showFilterBar: true,
    submitOnBlur: true,
    showDatePicker: false,
    showSubmitButton: false,
    placeholder: _i18n.i18n.translate('xpack.triggersActionsUI.sections.actionTypeForm.ActionAlertsFilterQueryPlaceholder', {
      defaultMessage: 'Filter alerts using KQL syntax'
    })
  })));
};
exports.ActionAlertsFilterQuery = ActionAlertsFilterQuery;