"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLoadAlertSummary = useLoadAlertSummary;
var _react = require("react");
var _constants = require("@kbn/rule-registry-plugin/common/constants");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLoadAlertSummary({
  featureIds,
  timeRange,
  filter
}) {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const [alertSummary, setAlertSummary] = (0, _react.useState)({
    isLoading: true,
    alertSummary: {
      activeAlertCount: 0,
      activeAlerts: [],
      recoveredAlertCount: 0
    }
  });
  const isCancelledRef = (0, _react.useRef)(false);
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  const loadAlertSummary = (0, _react.useCallback)(async () => {
    if (!featureIds) return;
    isCancelledRef.current = false;
    abortCtrlRef.current.abort();
    abortCtrlRef.current = new AbortController();
    try {
      const {
        activeAlertCount,
        activeAlerts,
        recoveredAlertCount
      } = await fetchAlertSummary({
        featureIds,
        filter,
        http,
        signal: abortCtrlRef.current.signal,
        timeRange
      });
      if (!isCancelledRef.current) {
        setAlertSummary(() => ({
          alertSummary: {
            activeAlertCount,
            activeAlerts,
            recoveredAlertCount
          },
          isLoading: false
        }));
      }
    } catch (error) {
      if (!isCancelledRef.current) {
        if (error.name !== 'AbortError') {
          setAlertSummary(oldState => ({
            ...oldState,
            isLoading: false,
            error: error.message
          }));
        }
      }
    }
  }, [featureIds, filter, http, timeRange]);
  (0, _react.useEffect)(() => {
    loadAlertSummary();
  }, [loadAlertSummary]);
  return alertSummary;
}
async function fetchAlertSummary({
  featureIds,
  filter,
  http,
  signal,
  timeRange: {
    utcFrom,
    utcTo,
    fixedInterval
  }
}) {
  var _res$activeAlertCount, _res$activeAlerts, _res$recoveredAlertCo;
  const res = await http.post(`${_constants.BASE_RAC_ALERTS_API_PATH}/_alert_summary`, {
    signal,
    body: JSON.stringify({
      fixed_interval: fixedInterval,
      gte: utcFrom,
      lte: utcTo,
      featureIds,
      filter: [filter]
    })
  });
  const activeAlertCount = (_res$activeAlertCount = res === null || res === void 0 ? void 0 : res.activeAlertCount) !== null && _res$activeAlertCount !== void 0 ? _res$activeAlertCount : 0;
  const activeAlerts = (_res$activeAlerts = res === null || res === void 0 ? void 0 : res.activeAlerts) !== null && _res$activeAlerts !== void 0 ? _res$activeAlerts : [];
  const recoveredAlertCount = (_res$recoveredAlertCo = res === null || res === void 0 ? void 0 : res.recoveredAlertCount) !== null && _res$recoveredAlertCo !== void 0 ? _res$recoveredAlertCo : 0;
  return {
    activeAlertCount,
    activeAlerts,
    recoveredAlertCount
  };
}