"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateConnector = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _action_connector_api = require("../lib/action_connector_api");
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreateConnector = () => {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const abortCtrlRef = (0, _react.useRef)(new AbortController());
  const isMounted = (0, _react.useRef)(false);
  async function createConnector(connector) {
    setIsLoading(true);
    isMounted.current = true;
    abortCtrlRef.current.abort();
    abortCtrlRef.current = new AbortController();
    try {
      const res = await (0, _action_connector_api.createActionConnector)({
        http,
        connector
      });
      if (isMounted.current) {
        setIsLoading(false);
        toasts.addSuccess(_i18n.i18n.translate('xpack.triggersActionsUI.sections.addConnectorForm.updateSuccessNotificationText', {
          defaultMessage: "Created '{connectorName}'",
          values: {
            connectorName: res.name
          }
        }));
      }
      return res;
    } catch (error) {
      if (isMounted.current) {
        setIsLoading(false);
        if (error.name !== 'AbortError') {
          var _error$body$message, _error$body;
          toasts.addDanger((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : _i18n.i18n.translate('xpack.triggersActionsUI.sections.useCreateConnector.updateErrorNotificationText', {
            defaultMessage: 'Cannot create a connector.'
          }));
        }
      }
    }
  }
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
      abortCtrlRef.current.abort();
    };
  }, []);
  return {
    isLoading,
    createConnector
  };
};
exports.useCreateConnector = useCreateConnector;