"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextAreaWithMessageVariables = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _get_experimental_features = require("../../common/get_experimental_features");
var _text_area_with_autocomplete = require("./text_area_with_autocomplete");
var _lib = require("../lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TextAreaWithMessageVariablesLegacy = ({
  messageVariables,
  paramsProperty,
  index,
  inputTargetValue,
  isDisabled = false,
  editAction,
  label,
  errors,
  helpText
}) => {
  const [currentTextElement, setCurrentTextElement] = (0, _react.useState)(null);
  const onSelectMessageVariable = variable => {
    var _currentTextElement$s, _currentTextElement$s2;
    const templatedVar = (0, _lib.templateActionVariable)(variable);
    const startPosition = (_currentTextElement$s = currentTextElement === null || currentTextElement === void 0 ? void 0 : currentTextElement.selectionStart) !== null && _currentTextElement$s !== void 0 ? _currentTextElement$s : 0;
    const endPosition = (_currentTextElement$s2 = currentTextElement === null || currentTextElement === void 0 ? void 0 : currentTextElement.selectionEnd) !== null && _currentTextElement$s2 !== void 0 ? _currentTextElement$s2 : 0;
    const newValue = (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').substring(0, startPosition) + templatedVar + (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').substring(endPosition, (inputTargetValue !== null && inputTargetValue !== void 0 ? inputTargetValue : '').length);
    editAction(paramsProperty, newValue, index);
  };
  const onChangeWithMessageVariable = e => {
    editAction(paramsProperty, e.target.value, index);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    error: errors,
    isDisabled: isDisabled,
    isInvalid: errors && errors.length > 0 && inputTargetValue !== undefined,
    label: label,
    labelAppend: /*#__PURE__*/_react.default.createElement(_alertsUiShared.AddMessageVariables, {
      messageVariables: messageVariables,
      onSelectEventHandler: onSelectMessageVariable,
      paramsProperty: paramsProperty
    }),
    helpText: helpText
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    disabled: isDisabled,
    fullWidth: true,
    isInvalid: errors && errors.length > 0 && inputTargetValue !== undefined,
    name: paramsProperty,
    value: inputTargetValue || '',
    "data-test-subj": `${paramsProperty}TextArea`,
    onChange: e => onChangeWithMessageVariable(e),
    onFocus: e => {
      setCurrentTextElement(e.target);
    },
    onBlur: () => {
      if (!inputTargetValue) {
        editAction(paramsProperty, '', index);
      }
    }
  }));
};
const TextAreaWithMessageVariables = props => {
  let isMustacheAutocompleteOn;
  try {
    isMustacheAutocompleteOn = (0, _get_experimental_features.getIsExperimentalFeatureEnabled)('isMustacheAutocompleteOn');
  } catch (e) {
    isMustacheAutocompleteOn = false;
  }
  if (isMustacheAutocompleteOn) return (0, _text_area_with_autocomplete.TextAreaWithAutocomplete)(props);
  return TextAreaWithMessageVariablesLegacy(props);
};
exports.TextAreaWithMessageVariables = TextAreaWithMessageVariables;