"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteModalConfirmation = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../common/lib/kibana");
var _translations = require("../sections/rules_list/translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DeleteModalConfirmation = ({
  idsToDelete,
  apiDeleteCall,
  onDeleted,
  onCancel,
  onErrors,
  singleTitle,
  multipleTitle,
  showWarningText,
  warningText,
  setIsLoadingState
}) => {
  const [deleteModalFlyoutVisible, setDeleteModalVisibility] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setDeleteModalVisibility(idsToDelete.length > 0);
  }, [idsToDelete]);
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  const numIdsToDelete = idsToDelete.length;
  if (!deleteModalFlyoutVisible) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    "data-test-subj": "deleteIdsConfirmation",
    title: (0, _translations.getConfirmDeletionButtonText)(numIdsToDelete, singleTitle, multipleTitle),
    onCancel: () => {
      setDeleteModalVisibility(false);
      onCancel();
    },
    onConfirm: async () => {
      setDeleteModalVisibility(false);
      setIsLoadingState(true);
      const {
        successes,
        errors
      } = await apiDeleteCall({
        ids: idsToDelete,
        http
      });
      setIsLoadingState(false);
      const numSuccesses = successes.length;
      const numErrors = errors.length;
      if (numSuccesses > 0) {
        toasts.addSuccess((0, _translations.getSuccessfulDeletionNotificationText)(numSuccesses, singleTitle, multipleTitle));
      }
      if (numErrors > 0) {
        toasts.addDanger((0, _translations.getFailedDeletionNotificationText)(numErrors, singleTitle, multipleTitle));
        await onErrors();
      }
      await onDeleted(successes);
    },
    cancelButtonText: _translations.CANCEL_BUTTON_TEXT,
    confirmButtonText: (0, _translations.getConfirmDeletionButtonText)(numIdsToDelete, singleTitle, multipleTitle)
  }, /*#__PURE__*/_react.default.createElement("p", null, (0, _translations.getConfirmDeletionModalText)(numIdsToDelete, singleTitle, multipleTitle)), showWarningText && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, warningText),
    color: "warning",
    iconType: "warning"
  }));
};
exports.DeleteModalConfirmation = DeleteModalConfirmation;